-- Add cpf and phone columns to referral_codes table
ALTER TABLE public.referral_codes 
ADD COLUMN IF NOT EXISTS cpf text,
ADD COLUMN IF NOT EXISTS phone text;

-- Create index for CPF lookups
CREATE INDEX IF NOT EXISTS idx_referral_codes_cpf ON public.referral_codes USING btree (cpf);

-- Drop existing restrictive policy
DROP POLICY IF EXISTS "Authenticated users can manage referral codes" ON public.referral_codes;

-- Policy: Anyone can insert referral codes (for public referral creation)
CREATE POLICY "Anyone can create referral codes"
ON public.referral_codes
FOR INSERT
WITH CHECK (true);

-- Policy: Authenticated users can update and delete referral codes
CREATE POLICY "Authenticated users can update referral codes"
ON public.referral_codes
FOR UPDATE
TO authenticated
USING (true)
WITH CHECK (true);

CREATE POLICY "Authenticated users can delete referral codes"
ON public.referral_codes
FOR DELETE
TO authenticated
USING (true);

-- Add comment
COMMENT ON COLUMN public.referral_codes.cpf IS 'CPF do indicador';
COMMENT ON COLUMN public.referral_codes.phone IS 'Telefone/WhatsApp do indicador';
