"use client"

import { Radio, X, Play, Pause } from "lucide-react"
import { useState, useRef, useEffect } from "react"

export function RadioPlayerFab() {
  const [isExpanded, setIsExpanded] = useState(false)
  const [isPlaying, setIsPlaying] = useState(false)
  const [mounted, setMounted] = useState(false)

  const audioRef = useRef<HTMLAudioElement>(null)

  const [isLoading, setIsLoading] = useState(false)


  useEffect(() => {
    setMounted(true)
  }, [])

  if (!mounted) return null

 const toggleExpanded = () => {
  setIsExpanded(!isExpanded)

  if (!isExpanded && audioRef.current) {
    audioRef.current.load() // pré-carrega o stream
  }

  if (isExpanded && audioRef.current) {
    audioRef.current.pause()
    setIsPlaying(false)
  }
}


  const togglePlay = async () => {
  if (!audioRef.current) return

  try {
    if (isPlaying) {
      audioRef.current.pause()
      setIsPlaying(false)
    } else {
      setIsLoading(true)
      await audioRef.current.play()
      setIsPlaying(true)
    }
  } catch (err) {
    console.error(err)
  } finally {
    setIsLoading(false)
  }
}


  return (
    <>
      {/* AUDIO REAL (INVISÍVEL) */}
      <audio ref={audioRef} src="https://stream.zeno.fm/7iaperwz4pkvv" preload="auto" playsInline />

      {/* Collapsed FAB */}
      {!isExpanded && (
        <div
          onClick={toggleExpanded}
          className="fixed bottom-24 left-8 z-50 flex items-center justify-center w-14 h-14 rounded-full bg-gradient-to-br from-emerald-500 to-emerald-600 shadow-lg border-2 border-white dark:border-gray-800 cursor-pointer transition-all hover:shadow-xl hover:scale-110 group"
        >
          <Radio className="h-6 w-6 text-white animate-pulse group-hover:animate-none" />
        </div>
      )}

      {/* Expanded Player */}
      {isExpanded && (
        <div className="fixed bottom-24 left-8 z-50 bg-card shadow-2xl border border-border rounded-2xl overflow-hidden transition-all w-50 lg:w-96 h-auto">
          {/* Header */}
          <div className="bg-gradient-to-r from-emerald-500 to-emerald-600 p-4 flex items-center justify-between">
            <div className="flex items-center gap-3">
              <Radio className="h-5 w-5 text-white" />
              <div>
                <h3 className="text-white font-semibold text-sm">Estação Uniporá</h3>
                <p className="text-emerald-100 text-xs">Rádio Universitária</p>
              </div>
            </div>

            <button
              onClick={toggleExpanded}
              className="text-white hover:bg-white/20 rounded-full p-1 transition-colors"
            >
              <X className="h-5 w-5" />
            </button>
          </div>

          {/* Controls */}
          <div className="p-4">
            <div className="flex items-center justify-center mb-4">
              <button
                onClick={togglePlay}
                className="rounded-full bg-gradient-to-br from-emerald-500 to-emerald-600 flex items-center justify-center text-white shadow-lg hover:shadow-xl transition-all hover:scale-105 w-16 h-16"
              >
                {isPlaying ? <Pause className="h-8 w-8 fill-white" /> : <Play className="w-8 fill-white ml-1 h-8" />}
              </button>
            </div>

            {/* Now Playing */}
            <div className="text-center mb-4">
              <p className="text-xs text-muted-foreground mb-1">Tocando agora</p>
              <p className="text-sm font-medium">
  {isLoading
    ? "Conectando à rádio..."
    : isPlaying
    ? "Estação Uniporá FM"
    : "Clique em Play"}
</p>

            </div>

            {/* Equalizer visual */}
            {isPlaying && (
              <div className="flex items-end justify-center gap-1 h-12">
                {[...Array(12)].map((_, i) => (
                  <div
                    key={i}
                    className="w-1.5 bg-gradient-to-t from-emerald-500 to-emerald-400 rounded-full animate-pulse"
                    style={{
                      height: `${Math.random() * 40 + 20}%`,
                      animationDelay: `${i * 0.1}s`,
                      animationDuration: `${Math.random() * 0.5 + 0.5}s`,
                    }}
                  />
                ))}
              </div>
            )}
          </div>

          {/* Footer */}
          <div className="bg-muted/50 px-4 py-2 text-center">
            <a
              href="https://zeno.fm/radio/estacao-unipora/"
              target="_blank"
              rel="noopener noreferrer"
              className="text-xs text-muted-foreground hover:text-emerald-600 transition-colors"
            >
              Ouvir no Zeno.FM
            </a>
          </div>
        </div>
      )}
    </>
  )
}
