import { Shield, Lock, Eye, FileCheck } from "lucide-react"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"

export function LgpdSection() {
  return (
    <section id="lgpd" className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <Shield className="h-12 w-12 text-primary mx-auto mb-4" />
            <h2 className="text-3xl md:text-4xl font-bold mb-4">LGPD - Proteção de Dados</h2>
            <p className="text-lg text-muted-foreground">Compromisso com a privacidade e segurança dos seus dados</p>
          </div>

          <div className="prose prose-lg max-w-none mb-8">
            <p className="text-muted-foreground leading-relaxed">
              A Uniporá está comprometida com a Lei Geral de Proteção de Dados (LGPD - Lei nº 13.709/2018) e adota todas
              as medidas necessárias para garantir a segurança e privacidade das informações pessoais de nossos alunos,
              colaboradores e parceiros.
            </p>
          </div>

          <div className="grid md:grid-cols-2 gap-6 mb-8">
            <Card>
              <CardHeader>
                <Lock className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Segurança</CardTitle>
                <CardDescription>Proteção das suas informações</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Utilizamos tecnologias avançadas e protocolos de segurança para proteger seus dados pessoais.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <Eye className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Transparência</CardTitle>
                <CardDescription>Clareza no uso dos dados</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Informamos de forma clara como seus dados são coletados, armazenados e utilizados.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <FileCheck className="h-8 w-8 text-primary mb-2" />
                <CardTitle>Seus Direitos</CardTitle>
                <CardDescription>Controle sobre seus dados</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Você tem direito a acessar, corrigir, excluir ou solicitar a portabilidade dos seus dados.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <Shield className="h-8 w-8 text-primary mb-2" />
                <CardTitle>DPO</CardTitle>
                <CardDescription>Encarregado de dados</CardDescription>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-muted-foreground">
                  Entre em contato com nosso DPO para questões relacionadas à proteção de dados.
                </p>
              </CardContent>
            </Card>
          </div>

          <div className="bg-muted p-6 rounded-lg">
            <h3 className="font-semibold mb-2">Política de Privacidade</h3>
            <p className="text-sm text-muted-foreground mb-4">
              Para mais informações sobre como tratamos seus dados pessoais, consulte nossa Política de Privacidade
              completa.
            </p>
            <p className="text-sm text-muted-foreground">
              <strong>Contato DPO:</strong> lgpd@unipora.edu.br
            </p>
          </div>
        </div>
      </div>
    </section>
  )
}
