import { Card, CardContent } from "@/components/ui/card"
import { Award, Users2, MapPin, Sparkles } from "lucide-react"

const differentials = [
  {
    icon: Award,
    title: "Ensino de Qualidade",
    description: "Currículo atualizado e alinhado com as demandas do mercado de trabalho moderno",
  },
  {
    icon: Users2,
    title: "Professores Qualificados",
    description: "Corpo docente com mestres e doutores experientes e dedicados ao ensino",
  },
  {
    icon: MapPin,
    title: "Localização Estratégica",
    description: "Situada em Iporá - GO, atendendo toda a região centro oeste de Goiás",
  },
  {
    icon: Sparkles,
    title: "Inovação e Tecnologia",
    description: "Metodologias ativas e recursos tecnológicos modernos no ensino",
  },
]

export function DifferentialsSection() {
  return (
    <section className="py-24 bg-card">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6 text-balance">Por Que Escolher a Uniporá?</h2>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto text-pretty">
            Nossos diferenciais fazem da Uniporá a melhor escolha para sua formação superior
          </p>
        </div>

        <div className="grid md:grid-cols-2 gap-8 max-w-5xl mx-auto">
          {differentials.map((item, index) => {
            const Icon = item.icon
            return (
              <Card key={index} className="border-2 hover:border-primary transition-all duration-300 hover:shadow-xl shadow-xs">
                <CardContent className="p-8 flex gap-6">
                  <div className="flex-shrink-0">
                    <div className="p-4 bg-primary/10 rounded-xl">
                      <Icon className="h-8 w-8 text-primary" />
                    </div>
                  </div>
                  <div>
                    <h3 className="text-2xl font-bold mb-3">{item.title}</h3>
                    <p className="text-muted-foreground leading-relaxed">{item.description}</p>
                  </div>
                </CardContent>
              </Card>
            )
          })}
        </div>
      </div>
    </section>
  )
}
