"use client"

import { useEffect, useState } from "react"

export function CoursesPageHero() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    setIsVisible(true)
  }, [])

  return (
    <section className="relative pt-32 pb-20 bg-gradient-to-br from-primary/10 via-background to-primary/5 overflow-hidden">
      <div
        className={`container mx-auto px-4 transition-all duration-1000 ${
          isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-8"
        }`}
      >
        <div className="max-w-3xl mx-auto text-center">
          <h1 className="text-5xl md:text-6xl font-bold text-balance mb-6 bg-gradient-to-br from-primary to-primary/70 bg-clip-text text-transparent">
            Conheça nossos cursos
          </h1>
          <p className="text-lg md:text-xl text-muted-foreground text-pretty max-w-2xl mx-auto">
            Explore as melhores opções de graduação, pós-graduação e cursos tecnólogos para construir seu futuro
            profissional com excelência.
          </p>
        </div>
      </div>

      {/* Decorative elements */}
      <div className="absolute top-20 left-10 w-20 h-20 bg-primary/10 rounded-full blur-3xl" />
      <div className="absolute bottom-10 right-10 w-32 h-32 bg-primary/10 rounded-full blur-3xl" />
    </section>
  )
}
