import { Card, CardContent } from "@/components/ui/card"
import { Microscope, Users, Building2, Trophy } from "lucide-react"

const features = [
  {
    icon: Microscope,
    title: "Laboratórios Modernos",
    description: "Infraestrutura de ponta para práticas e pesquisas acadêmicas",
  },
  {
    icon: Users,
    title: "Projetos de Extensão",
    description: "Conecte-se com a comunidade através de projetos sociais",
  },
  {
    icon: Building2,
    title: "Estrutura Completa",
    description: "Biblioteca, salas climatizadas e espaços de convivência",
  },
  {
    icon: Trophy,
    title: "Eventos Acadêmicos",
    description: "Workshops, palestras e congressos durante todo o ano",
  },
]

export function CampusLifeSection() {
  return (
    <section id="aluno" className="py-24 bg-background">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6 text-balance">Vida Acadêmica</h2>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto text-pretty">
            Na Uniporá, você vive uma experiência universitária completa, com oportunidades de crescimento pessoal e
            profissional
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6 max-w-6xl mx-auto">
          {features.map((feature, index) => {
            const Icon = feature.icon
            return (
              <Card
                key={index}
                className="text-center hover:shadow-lg transition-all duration-300 hover:-translate-y-1 shadow-xs"
              >
                <CardContent className="p-6">
                  <div className="inline-flex p-4 bg-primary/10 rounded-xl mb-4">
                    <Icon className="h-8 w-8 text-primary" />
                  </div>
                  <h3 className="text-xl font-bold mb-3">{feature.title}</h3>
                  <p className="text-muted-foreground text-sm leading-relaxed">{feature.description}</p>
                </CardContent>
              </Card>
            )
          })}
        </div>

        {/* Image showcase */}
        <div className="grid md:grid-cols-3 gap-4 mt-16 max-w-6xl mx-auto">
          <div className="aspect-video rounded-xl overflow-hidden">
            <img
              src="/university-laboratory-students.jpg"
              alt="Laboratórios"
              className="w-full h-full object-cover hover:scale-105 transition-transform duration-500"
            />
          </div>
          <div className="aspect-video rounded-xl overflow-hidden">
            <img
              src="/university-students-event.jpg"
              alt="Eventos"
              className="w-full h-full object-cover hover:scale-105 transition-transform duration-500"
            />
          </div>
          <div className="aspect-video rounded-xl overflow-hidden">
            <img
              src="/university-library-modern.jpg"
              alt="Biblioteca"
              className="w-full h-full object-cover hover:scale-105 transition-transform duration-500"
            />
          </div>
        </div>
      </div>
    </section>
  )
}
