import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { CheckCircle2 } from "lucide-react"
import Link from "next/link"

export function AdmissionSection() {
  const steps = [
    "Escolha seu curso ideal",
    "Preencha o formulário de inscrição online",
    "Envie sua documentação",
    "Realize a prova ou utilize sua nota do ENEM",
    "Efetue a matrícula e comece sua jornada",
  ]

  return (
    <section id="ingresso" className="py-24 bg-card">
      <div className="container mx-auto px-4">
        <div className="grid lg:grid-cols-2 gap-12 items-center max-w-6xl mx-auto">
          <div>
            <h2 className="text-4xl md:text-5xl font-bold mb-6 text-balance">Processo de Ingresso</h2>
            <p className="text-xl text-muted-foreground mb-8 leading-relaxed">
              Ingressar na Uniporá é simples e rápido. Siga os passos abaixo e comece sua transformação profissional.
            </p>

            <div className="space-y-4 mb-8">
              {steps.map((step, index) => (
                <div key={index} className="flex gap-4 items-start">
                  <div className="flex-shrink-0 w-8 h-8 rounded-full bg-primary text-primary-foreground flex items-center justify-center font-bold">
                    {index + 1}
                  </div>
                  <p className="text-lg pt-0.5">{step}</p>
                </div>
              ))}
            </div>

            <Button size="lg" asChild className="text-lg px-8 py-6">
              <Link href="/matricula">Iniciar Inscrição</Link>
            </Button>
          </div>

          <Card className="border-border border shadow-xs bg-background">
            <CardContent className="p-8">
              <h3 className="text-2xl font-bold mb-6">Rematrícula Online</h3>
              <p className="text-muted-foreground mb-6 leading-relaxed">
                Já é aluno da Uniporá? Renove sua matrícula de forma rápida e prática pelo nosso sistema online.
              </p>
              <div className="space-y-3 mb-8">
                <div className="flex items-center gap-3">
                  <CheckCircle2 className="h-5 w-5 text-primary flex-shrink-0" />
                  <span>Processo 100% digital</span>
                </div>
                <div className="flex items-center gap-3">
                  <CheckCircle2 className="h-5 w-5 text-primary flex-shrink-0" />
                  <span>Sem filas ou burocracia</span>
                </div>
                <div className="flex items-center gap-3">
                  <CheckCircle2 className="h-5 w-5 text-primary flex-shrink-0" />
                  <span>Confirmação imediata</span>
                </div>
              </div>
              <Button variant="outline" size="lg" asChild className="w-full bg-primary text-background border-primary">
                <Link href="#rematricula">Renovar Matrícula</Link>
              </Button>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  )
}
