import { TopBar } from "@/components/top-bar"
import { Header } from "@/components/header"
import { Footer } from "@/components/footer"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { BookOpen, Users, Monitor, Award, FileText, GraduationCap } from "lucide-react"

export default function NEADPage() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-gray-50 to-white dark:from-gray-900 dark:to-gray-800">
      <TopBar />
      <Header />

      <main className="pt-32">
        {/* Hero Section with Video */}
        <section className="container mx-auto px-4 py-12">
          <div className="max-w-4xl mx-auto text-center mb-8">
            <h1 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white mb-4">
              NEAD - Núcleo de Ensino à Distância
            </h1>
            <p className="text-xl text-gray-600 dark:text-gray-300">Centro Universitário de Iporá - UNIPORÁ</p>
          </div>

          {/* YouTube Video Container */}
          <div className="max-w-5xl mx-auto mb-16">
            <div className="relative aspect-video rounded-2xl overflow-hidden shadow-2xl bg-gray-900">
              <iframe
                className="absolute inset-0 w-full h-full"
                src="https://www.youtube.com/embed/BMjet6eTPcs"
                title="NEAD - Núcleo de Ensino à Distância"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowFullScreen
              />
            </div>
          </div>

          {/* O QUE É O NEAD */}
          <div className="max-w-4xl mx-auto mb-16">
            <Card className="border-emerald-200 dark:border-emerald-800">
              <CardHeader>
                <CardTitle className="text-2xl text-emerald-700 dark:text-emerald-400">O que é o NEAD?</CardTitle>
              </CardHeader>
              <CardContent className="text-gray-700 dark:text-gray-300 space-y-4">
                <p className="text-lg leading-relaxed">
                  É um departamento responsável por projetar, organizar e apoiar a Educação a Distância no Centro
                  Universitário de Iporá – UNIPORÁ, conforme Portaria nº 2.117, de 6 de dezembro de 2019.
                </p>
                <p className="leading-relaxed">
                  O NEAD atua diretamente na implantação e desenvolvimento de projetos e cursos na Modalidade EAD,
                  oferecendo todo suporte técnico na plataforma AVA (Ambiente Virtual de Aprendizagem) para o
                  desenvolvimento pleno do cursista e/ou acadêmico.
                </p>
              </CardContent>
            </Card>
          </div>

          {/* O PAPEL DO NEAD */}
          <div className="max-w-4xl mx-auto mb-16">
            <Card className="border-blue-200 dark:border-blue-800">
              <CardHeader>
                <CardTitle className="text-2xl text-blue-700 dark:text-blue-400">
                  O Papel do Núcleo de Ensino a Distância
                </CardTitle>
              </CardHeader>
              <CardContent className="text-gray-700 dark:text-gray-300 space-y-4">
                <p className="leading-relaxed">
                  Todo o trabalho desenvolvido acontece em consonância com as políticas de desenvolvimento de Educação a
                  Distância do Centro Universitário de Iporá, estabelecidas no Projeto Pedagógico Institucional (PPI)
                  vinculadas ao Projeto de Desenvolvimento Institucional (PDI) com vigência de 2021 – 2025.
                </p>
                <p className="leading-relaxed">
                  É de competência do Núcleo de Ensino a Distância planejar, implementar, executar e avaliar estratégias
                  para o desdobramento e o aperfeiçoamento de metodologias de ensino que contemplem o Ensino a Distância
                  e o Ensino Híbrido, por meio de ações pedagógicas, tecnologias e administrativas que valorizem o
                  ensino por meio de múltiplas linguagens.
                </p>
                <p className="leading-relaxed">
                  O NEAD é responsável pela adoção e gestão de tecnologias de comunicação e informação (TIC's) como o
                  Ambiente Virtual de Aprendizagem (AVA) e Microsoft Teams, pela gestão do processo de elaboração e
                  produção de materiais didáticos digitais.
                </p>
              </CardContent>
            </Card>
          </div>

          {/* ESPAÇO DO PROFESSOR E ALUNO */}
          <div className="max-w-5xl mx-auto mb-16">
            <h2 className="text-3xl font-bold text-center text-gray-900 dark:text-white mb-8">Nossos Ambientes</h2>
            <div className="grid md:grid-cols-2 gap-8">
              {/* Espaço do Professor */}
              <a
                href="https://portal.unipora.edu.br/login/index.php"
                target="_blank"
                rel="noopener noreferrer"
                className="group"
              >
                <div className="relative h-56 md:h-64 rounded-full overflow-hidden bg-gradient-to-br from-[#0a2540] to-[#1e4976] shadow-2xl hover:shadow-emerald-500/50 transition-all duration-300 hover:scale-105">

              <div className="absolute inset-0 flex flex-col items-center justify-center text-white px-6 gap-0">
  <GraduationCap className="w-16 h-16 opacity-20" />
  <h3 className="text-2xl md:text-3xl font-bold text-center leading-tight">

                      ESPAÇO DO
                      <br />
                      PROFESSOR
                    </h3>
                  </div>
                </div>
              </a>

              {/* Espaço do Aluno */}
              <a href="https://portal.unipora.edu.br/login/index.php" target="_blank" rel="noopener noreferrer" className="group">
               <div className="relative h-56 md:h-64 rounded-full overflow-hidden bg-gradient-to-br from-[#0a2540] to-[#1e4976] shadow-2xl hover:shadow-emerald-500/50 transition-all duration-300 hover:scale-105">

                  <div className="absolute inset-0 flex flex-col items-center justify-center text-white p-8">
                  <BookOpen className="w-16 h-16 opacity-20" />
<h3 className="text-2xl md:text-3xl font-bold text-center leading-tight">

                      ESPAÇO DO
                      <br />
                      ALUNO
                    </h3>
                  </div>
                </div>
              </a>
            </div>
          </div>

          {/* OFERTAS */}
          <div className="max-w-5xl mx-auto mb-16">
            <h2 className="text-3xl font-bold text-center text-gray-900 dark:text-white mb-8">Ofertas do NEAD</h2>
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
              <Card className="hover:shadow-lg transition-shadow">
                <CardHeader>
                  <Monitor className="w-10 h-10 text-emerald-600 mb-2" />
                  <CardTitle className="text-lg">Unidades Curriculares Híbridas</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600 dark:text-gray-400">
                    Ofertas com carga horária híbrida dos cursos de Graduação
                  </p>
                </CardContent>
              </Card>

              <Card className="hover:shadow-lg transition-shadow">
                <CardHeader>
                  <Monitor className="w-10 h-10 text-emerald-600 mb-2" />
                  <CardTitle className="text-lg">Unidades 100% Online</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600 dark:text-gray-400">
                    Ofertas de Unidades Curriculares totalmente online dos cursos de Graduação
                  </p>
                </CardContent>
              </Card>

              <Card className="hover:shadow-lg transition-shadow">
                <CardHeader>
                  <Award className="w-10 h-10 text-emerald-600 mb-2" />
                  <CardTitle className="text-lg">Cursos Livres</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600 dark:text-gray-400">Cursos livres de curta duração à distância</p>
                </CardContent>
              </Card>

              <Card className="hover:shadow-lg transition-shadow">
                <CardHeader>
                  <FileText className="w-10 h-10 text-emerald-600 mb-2" />
                  <CardTitle className="text-lg">Cursos de Extensão</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600 dark:text-gray-400">Ofertas de cursos de extensão à distância</p>
                </CardContent>
              </Card>

              <Card className="hover:shadow-lg transition-shadow">
                <CardHeader>
                  <Users className="w-10 h-10 text-emerald-600 mb-2" />
                  <CardTitle className="text-lg">Qualificação Profissional</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600 dark:text-gray-400">
                    Cursos de qualificação à distância/híbrido para técnicos e docentes
                  </p>
                </CardContent>
              </Card>

              <Card className="hover:shadow-lg transition-shadow">
                <CardHeader>
                  <GraduationCap className="w-10 h-10 text-emerald-600 mb-2" />
                  <CardTitle className="text-lg">Educação Continuada</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-sm text-gray-600 dark:text-gray-400">
                    Oferta de educação continuada e capacitação no AVA
                  </p>
                </CardContent>
              </Card>
            </div>
          </div>

          {/* ATIVIDADES */}
          <div className="max-w-4xl mx-auto mb-16">
            <Card className="border-purple-200 dark:border-purple-800">
              <CardHeader>
                <CardTitle className="text-2xl text-purple-700 dark:text-purple-400">
                  Atividades do Núcleo a Distância
                </CardTitle>
              </CardHeader>
              <CardContent>
                <ul className="space-y-3 text-gray-700 dark:text-gray-300">
                  <li className="flex items-start">
                    <span className="text-emerald-600 mr-2">•</span>
                    <span>Estruturação de conteúdos e unidades curriculares na plataforma</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-emerald-600 mr-2">•</span>
                    <span>Atendimento ao público via canais de comunicação e presencial</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-emerald-600 mr-2">•</span>
                    <span>Capacitação no Ambiente Virtual de Aprendizagem</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-emerald-600 mr-2">•</span>
                    <span>Suporte técnico contínuo para docentes e discentes</span>
                  </li>
                </ul>
              </CardContent>
            </Card>
          </div>

          {/* COORDENAÇÃO */}
          <div className="max-w-4xl mx-auto mb-16">
            <Card className="border-orange-200 dark:border-orange-800">
              <CardHeader>
                <CardTitle className="text-2xl text-orange-700 dark:text-orange-400">
                  Coordenação do Núcleo de Ensino a Distância
                </CardTitle>
              </CardHeader>
              <CardContent className="space-y-4">
                <p className="text-gray-700 dark:text-gray-300 leading-relaxed">
                  O NEAD – UNIPORÁ é constituído pela equipe multidisciplinar, sendo composto por: coordenadores de
                  curso, professores conteudistas, professores formadores, tutores, coordenador de TI, e técnicos
                  administrativos, os quais são coordenados por um professor efetivo da instituição com experiência na
                  área de Ensino a Distância.
                </p>
                <div className="bg-emerald-50 dark:bg-emerald-900/20 p-6 rounded-lg mt-6">
                  <h3 className="font-bold text-lg text-emerald-700 dark:text-emerald-400 mb-2">
                    Coordenação do Núcleo de Ensino a Distância
                  </h3>
                  <p className="font-semibold text-gray-900 dark:text-white mb-2">Prof.ª Sávia Kauara S. R. Peres</p>
                  <p className="text-sm text-gray-700 dark:text-gray-300">
                    Graduada em Administração de Empresas – FAI 2019 | Licenciada em Pedagogia e Educação Profissional e
                    Tecnológica - Instituto Federal Goiano IF Goiano 2022 | Especialista em Docência Universitária UNIP
                    2020
                  </p>
                </div>
              </CardContent>
            </Card>
          </div>

          {/* MAIS INFORMAÇÕES */}
          <div className="max-w-4xl mx-auto mb-16">
            <Card className="border-teal-200 dark:border-teal-800">
              <CardHeader>
                <CardTitle className="text-2xl text-teal-700 dark:text-teal-400">
                  Mais Informações sobre o Núcleo de Ensino a Distância
                </CardTitle>
              </CardHeader>
              <CardContent className="text-gray-700 dark:text-gray-300 space-y-4">
                <p className="leading-relaxed">
                  O ano de 2020 foi um marco para o NEAD-UNIPORÁ, devido aos desafios promovidos pela pandemia da
                  COVID-19, sendo fundamental para a implementação do modelo de ensino remoto, orientando e qualificando
                  docentes e discentes por meio de oficinas virtuais, lives, vídeos, entre outros disponibilizados pelo
                  Centro Universitário de Iporá – UNIPORÁ, alcançando resultados positivos em avaliação interna
                  realizada pelos acadêmicos dos cursos de graduação.
                </p>
                <p className="leading-relaxed">
                  O NEAD também tem analisado e discutido propostas didáticas pedagógicas e tecnológicas para
                  credenciamento do Centro Universitário de Iporá – Uniporá para ofertas de cursos de graduação e
                  pós-graduação totalmente a distância.
                </p>
                <p className="leading-relaxed">
                  Sabemos que a tecnologia e o modelo de Ensino a Distância é de fato uma alternativa plausível para
                  alcançar a diversidade e necessidade dos nossos acadêmicos.
                </p>
                <p className="leading-relaxed font-semibold">
                  Sendo assim, trabalhamos constantemente para atender e dar o suporte necessário para o pleno
                  desenvolvimento do usuário do AVA.
                </p>
              </CardContent>
            </Card>
          </div>
        </section>
      </main>

      <Footer />
    </div>
  )
}
